* Title: 	figure13.do
* Version: 	23 May 2018
* Purpose: 	Produce graph of opioid consumption


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/figures/log/figure13, text replace
set more off
clear all
macro drop _all

* Install maptile geography
maptile_install using "http://files.michaelstepner.com/geo_county2014.zip", replace


*******************************************************************************
* (1) Load data
*******************************************************************************

use dta/cdc_opioid_clean, clear

keep county MME_PerCap_2015

* Save dataset
compress
save output/figures/dta/figure13.dta, replace

*******************************************************************************
* (2) Produce graph
*******************************************************************************


maptile	MME_PerCap_2015, geo(county2014) conus  ///
		cutvalues(300(200)1100) ///
		twopt(legend(size(small) title("MME per person", size(small))  ///
		lab(2 "< 300")  ///
		lab(3 "300 - 500")  ///
		lab(4 "500 - 700")  ///
		lab(5 "700 - 900")  ///
		lab(6 "900 - 1100")  ///
		lab(7 "> 1100")))


graph save output/figures/gph/figure13, replace
graph export output/figures/eps/figure13.eps, as(eps) replace
export excel using output/figures/xlsx/figure13.xlsx, first(variables) replace


*******************************************************************************
* (3) End of file
*******************************************************************************

log close
exit, clear
